package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;



public class Stallion_R_door extends HatchDoor
{
	public Stallion_R_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Stallion rear door";

		value = 566;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_03.stallion:0x000000E2r, "R windshield", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_03.stallion:0x000000E2r, "R windshield", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical > 1.0 )
		{
			float part_random = random();
			if ( part_random >= 0.5 ) addPart( cars.cat_03.stallion:0x000000DFr, "R wing 2", actcolor, optical, power ); else
			addPart( cars.cat_03.stallion:0x000000F2r, "R wing", actcolor, optical, power );
		}
	}
}
